<%@ Page Title="TBI Instruments - Upper Extremity Short Form 7A Questions / Answers" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="UpperExtremityShortForm7A.aspx.cs" Inherits="TBI_UpperExtremityShortForm7A" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register TagPrefix="VA" TagName="RehabilitationProviderSelector" Src="~/controls/RehabilitationProviderSelector.ascx" %>
<%@ Register TagPrefix="VA" TagName="TypeOfServiceSelector" Src="~/controls/TypeOfServiceSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" tagprefix="web" %>


<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">

<link type = "text/css" href ="~/styles/StyleSheet.css" />
    
    <style type="text/css">
            .breadcrumbInstrument {
                background-color:#6B1424;
                border-bottom:1px solid #000;
                color:#FFF;
                font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
                font-variant:small-caps;
                font-weight:700;
                letter-spacing:1px;
                margin: 2px 0 2px 0;
                padding:8px 25px 5px 10px;
            }
            
    </style>
</asp:Content> 

 <asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" AsyncPostBackTimeOut="400" runat="server">
    </asp:ScriptManager>
    
    <script type="text/javascript">
        var tmr = null;

        function getTimerReference() {
            if (tmr == null) {
                tmr = $find("<%= InactiveTimer.ClientID %>");
            }

            return tmr;
        }

        function StopTimer() {
            // alert('stop');
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            //alert('start');
            getTimerReference()._startTimer();
        }

        function startRequest(sender, e) {
            StartTimer();
            //disable button during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            $('#<%= PanelQuestions.ClientID %>').hide();
        }
        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
        }

    </script>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
<script type = "text/javascript">

    $(document).ready(function () {

        //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
        //also resets inactive timer
        $('input').keydown(function (e) {
            StopTimer();
            StartTimer();
            //if (e.keyCode == 13) { return false; }
        });

        //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
        //also resets inactive timer
        $('div').keydown(function (e) {
            StopTimer();
            StartTimer();
            //if (e.keyCode == 13) { return false; }
        });

        //resets inactive timer on click of a radio element
        $('input[type=radio]').click(function (e) {
            StopTimer();
            StartTimer();
        });

        //resets inactive timer on click of a checkbox element
        $('input[type=checkbox]').click(function (e) {
            StopTimer();
            StartTimer();
        });


        processRadioButtonQ_Click();

        window.onbeforeunload = function () {
            return;
        }
    });                      // END $(document).ready(function()

    function clearRadioButtonListSelection(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");

        var currIndex = GetListIndexSelected(listName);
        if (currIndex > -1) {
            radio[currIndex].checked = false;
        }
    }

    function GetListIndexSelected(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        for (var i = 0; i < radio.length; i++) {
            if (radio[i].checked) {
                ret = i;
                break;
            }
        }

        return ret;

    }

    function GetListValueSelected(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var hiddenNoteID = $('<%=prevNoteID.ClientID%>');
        var ret = "";

        for (var i = 0; i < radio.length; i++) {
            if (radio[i].checked) {
                ret = radio[i].value;
                var o = ret.split(',');

                hiddenNoteID.value = o[0].toString();
                var _rbNoteType = document.getElementById("<%=rbNoteType.ClientID%>");
                var radio2 = _rbNoteType.getElementsByTagName("input");
                var spn = _rbNoteType.getElementsByTagName("span");
                //if (((o[1].toString() == "0"))) {
                //    alert("nobody");
                //}

                switch (o[2].toString()) {
                    case "0":
                        //radio2.items[1].Enabled = true;
                        //radio2.items[2].Enabled = true;
                        //radio2.items[3].Enabled = false;
                        break;
                    default:
                        //radio2[1].Enabled = "true";
                        //radio2[2].Enabled = "true";
                        //radio2[3].Enabled = "false";
                }

                break;
            }
        }

        return ret;

    }
    function processRadBtnPrevNotes_Click() {
        var InitialNote = GetListValueSelected("<%=prevNotesList.ClientID%>");
    }


    function GetListIndexSelectedValue(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        for (var i = 0; i < radio.length; i++) {
            if (radio[i].checked) {
                switch (i) {
                    case 0:
                        ret = 5;
                        break;
                    case 1:
                        ret = 4;
                        break;
                    case 2:
                        ret = 3;
                        break;
                    case 3:
                        ret = 2;
                        break;
                    default:
                        ret = 1;
                        break;
                }
                break;
            }
        }

        return ret;

    }

    function processRadioButtonQ_Click() {
        //Calculate Raw Score
        var rawScore;

        var q1 = GetListIndexSelectedValue("<%=RadioButtonListQ1.ClientID%>");
        var q2 = GetListIndexSelectedValue("<%=RadioButtonListQ2.ClientID%>");
        var q3 = GetListIndexSelectedValue("<%=RadioButtonListQ3.ClientID%>");
        var q4 = GetListIndexSelectedValue("<%=RadioButtonListQ4.ClientID%>");
        var q5 = GetListIndexSelectedValue("<%=RadioButtonListQ5.ClientID%>");
        var q6 = GetListIndexSelectedValue("<%=RadioButtonListQ6.ClientID%>");
        var q7 = GetListIndexSelectedValue("<%=RadioButtonListQ7.ClientID%>");
        
        if ((q1 < 0) || (q2 < 0) || (q3 < 0) || (q4 < 0) || (q5 < 0) || (q6 < 0) || (q7 < 0)) {
            rawScore = "0";
        }
        else {
            rawScore = q1 + q2 + q3 + q4 + q5 + q6 + q7;
        }

        var lblRawScore = document.getElementById("<%=LabelRawScore.ClientID%>");
        lblRawScore.innerText = rawScore;
        document.getElementById("<%=hiddenRawScore.ClientID%>").value = rawScore;

        var lblRawScore_2 = document.getElementById("<%=LabelRawScore_2.ClientID%>");
        lblRawScore_2.innerText = rawScore;
        document.getElementById("<%=hiddenRawScore_2.ClientID%>").value = rawScore;
    };

    function GetLastElementIndex(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        ret = radio.length - 1;

        return ret;
    }

    function btnSaveButtonChange_Click() {
        //Save draft if question 8,15,16V,28 is changed occurs
        //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
        //alert("Auto-Saving");
    }

</script> 
</telerik:RadCodeBlock>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
<div id="skiplink">
    <a href="#content">skip to page content</a>
</div>
<asp:Menu 
    ID="Menu2" 
    runat="server" 
    SkipLinkText="Skip Left Navigation Links"
    DynamicHorizontalOffset="2"  Width="166px" 
    StaticMenuItemStyle-CssClass = "leftMenuItem"  
    DynamicMenuItemStyle-CssClass = "leftMenuItem"  
    StaticDisplayLevels="3" Height="134px" 
    onmenuitemclick="Menu2_MenuItemClick" >
    <StaticHoverStyle CssClass= "leftMenuItemHover" />
    <DynamicHoverStyle CssClass= "leftMenuItemHover" />
</asp:Menu>
<div class="breadcrumbInstrument">
        <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > PROMIS - Upper Extremity Short Form 7a"></asp:Label> 
</div>
</telerik:RadCodeBlock>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock4">
<asp:UpdatePanel ID="MainUpdatePanel" runat="server">
    <ContentTemplate>
            <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" 
                TabIndex="1" 
                HeaderText="The page has the following data errors:" 
                DisplayMode="BulletList" 
                ShowSummary="false" 
                ShowMessageBox="true" 
                ValidationGroup="OnSave" 
            />
        <asp:Panel ID="ProcessingPanel" runat="server" Visible="false">   
        <br />
            <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
            <ProgressTemplate>
                <!-- Modal Popup for Loading -->
              <div style="padding-left: 3px;" >
                    <div style="background-color: #FF0000; width: 300px; color: #FFFFFF; padding: 5px;">
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Processing...Please wait.
                    </div>
                </div>
              
                <!-- End Modal Popup for Loading -->
            </ProgressTemplate>
        </asp:UpdateProgress>
        <br />
</asp:Panel>
            <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">

            <table cellpadding = "5" cellspacing = "5">
                <tr>
                    <td>
                         &nbsp;&nbsp;<asp:Label ID = "LabelForName" runat = "server" Text = "Patient:" AssociatedControlID = "LabelPatient" SkinID="DataLabel"  TabIndex="2"></asp:Label>&nbsp;
                        <asp:Label ID="LabelPatient" runat = "server" SkinID="DataLabel" TabIndex="3"></asp:Label></td>
                    <td>
                        <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelSSN" Text = "SSN:" TabIndex="4"></asp:Label>
                        &nbsp;<asp:Label ID="LabelSSN" runat = "server" SkinID="DataLabel" TabIndex="5"></asp:Label></td>
                    <td>
                        <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" TabIndex="6" AssociatedControlID = "LabelFacility" Text = "Facility:" Visible="false"></asp:Label>
                        &nbsp;<asp:Label ID="LabelFacility" runat = "server" SkinID="DataLabel" TabIndex="7"></asp:Label></td>
                </tr>
            </table>
            </asp:Panel>
                 
            <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="PISF" />
            
            <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server">
                <table cellpadding = "5" cellspacing = "5" width = "100%" border="1">
                    <tr align="center">
                        <td colspan="2">
                            <asp:Label ID="LabelInstrumentTitle" runat="server" style="font-weight:bold;font-size:14px"  SkinID="DataLabel" TabIndex="8" />
              
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="RawScoreLabel_2" AssociatedControlID="LabelRawScore_2" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel" TabIndex="9">
                            Raw Score:&nbsp;
                            </asp:Label>
                            <asp:Label ID="LabelRawScore_2" runat="server" CssClass="firstLevelAnswer" SkinID="DataLabel" TabIndex="10">
                            </asp:Label>
                            <asp:HiddenField ID="hiddenRawScore_2" runat="server" Value="N/A"  />
                            
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        </td>
                                     
                    </tr>
  
                    <tr>
                        
                        <td width="100%" colspan="2">
                             <asp:Label ID="LabelNoteDate" AssociatedControlID="prevNotesList" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIndex="11">
                            Previous Initial Instrument Dates:
                            </asp:Label>
                            <table><tr><td>
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                                
                            <asp:RadioButtonList ID="prevNotesList" runat="server" RepeatDirection="Vertical"
                                AutoPostBack="true"
                                OnSelectedIndexChanged="Index_Changed"
                                DataTextField="prevM2PINoteInfo"
                                DataValueField="Surveys_ID"
                                AppendDataBoundItems="true"  SkinID="DataLabel" TabIndex="12">
                                <asp:ListItem Text = "New Instance of Care  Do not add to prior notes" Value = "self"></asp:ListItem>  
                            </asp:RadioButtonList>
                                
                            <asp:HiddenField ID="prevNoteID" runat="server" Visible="True" Value="" />
                            </td>
                            <td>
                        </td></tr></table>      
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            &nbsp;&nbsp;&nbsp;&nbsp;<asp:Label ID="NoteTypeLabel" runat="server" AssociatedControlID = "LabelNoteType"  SkinID="DataLabel" TabIndex="13">Note Type:</asp:Label>
                            <asp:Label ID="LabelNoteTypeID" runat="server" visible="false"  SkinID="DataLabel" TabIndex="14"></asp:Label>
                            &nbsp;<asp:Label ID="LabelNoteType" runat="server" visible="false" SkinID="DataLabel"  TabIndex="15"></asp:Label>
                        <asp:RadioButtonList ID="rbNoteType" runat="server" RepeatDirection="Horizontal"  
                            DatasourceID="ObjectDataSource1"
                            DataTextField="CHOICE_TEXT"
                            DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="processRadioButtonQ_Click()"
                            SkinID="DataLabel" TabIndex="16">
                        </asp:RadioButtonList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator1"
                            ControlToValidate="rbNoteType"
                            Display="Static"
                            runat="server"
                            EnableClientScript="true"
                            ErrorMessage = "Note type is required."
                            SetFocusOnError="true"
                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIndex="17">
                        </asp:RequiredFieldValidator>
                        <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" 
                            SelectMethod="GetQuestionChoices"
                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                            <SelectParameters>
                                <asp:ControlParameter ControlID="Question_Number" Direction="Input" Name="questionNumber" Type="String" />
                            </SelectParameters>
                        </asp:ObjectDataSource>
                        <asp:HiddenField ID="Question_Number" runat="server" Visible="false" Value="-1" />
                        <asp:HiddenField ID="SurveyDate" runat="server" Visible="false"  />
                    </tr>
                    <tr>
                        <td colspan="2">
                            <!-- Diagnosis Control -->
                            <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                            <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="18" />
                               
                        </td>
                    </tr>
                        <tr>
                        <td colspan="2">
                            <!-- RehabilitationProviderSelector Control -->
                            <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                            <VA:RehabilitationProviderSelector ID="cntlRehabilitationProviderSelector" runat="server" QuestionNumber="RP" StartTabIndex="19" />
                               
                        </td>
                    </tr>
                        <tr>
                        <td colspan="2">
                            <!-- TypeOfServiceSelector Control -->
                            <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                            <VA:TypeOfServiceSelector ID="cntlTypeOfServiceSelector" runat="server" QuestionNumber="TS" StartTabIndex="20" />
                                
                        </td>
                    </tr>
                </table>
            </asp:Panel>
            <br />
             <asp:Panel ID="pnlCopyRight" Width="100%" HorizontalAlign="Center" runat="server">
                
                        <asp:Label ID="lblCopyRight"   runat="server" Font-Bold="true" CssClass="firstLevelQuestion" SkinID="DataLabel" TabIndex="21" />
                
            </asp:Panel><br />
            <asp:Panel ID="PanelQuestions" runat="server">
                 <table cellpadding = "5" cellspacing = "5" width = "100%" border="1" >
              
               
                <tr><td class="questionBackgroundColor">
                    <asp:Label ID="lblPF1" runat="server" Font-Bold="true"   SkinID="DataLabel" TabIndex="22">
                    </asp:Label>
                </td></tr>
                    <tr><td >
                        <table  width="100%">
                        <tr><td >
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;</td></td></tr></table>
                 </td>   
           
                    </tr>
                    <tr id="TrQ1">
                        <td class="questionBackgroundColor">
        
                                        <asp:Label ID="Q1Label" AssociatedControlID="RadioButtonListQ1" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIndex="23">
                                        </asp:Label>
                                    </td>
                                  
                                </tr>
                                <tr>
                   
                                    <td >
                                        <asp:RadioButtonList ID="RadioButtonListQ1" runat="server" RepeatDirection="Horizontal"
                                            DatasourceID="ObjectDataSourceQ1"
                                            DataTextField="CHOICE_TEXT"  width="100%"
                                            DataValueField="STD_QUESTION_CHOICE_ID" 
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIndex="24">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1"
                                            ControlToValidate="RadioButtonListQ1"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 1 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel"  TabIndex="25">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="PFA14r1" />
                                    </td>
                                </tr>   

                    <tr id="TrQ2">
                        <td class="questionBackgroundColor">
  
                                        <asp:Label ID="Q2Label" AssociatedControlID="RadioButtonListQ2" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIndex="26">
                                        </asp:Label>
                                    </td>
                           
                                </tr>
                                <tr>
                               
                                    <td>
                                        <asp:RadioButtonList ID="RadioButtonListQ2" runat="server" RepeatDirection="Horizontal"
                                            DatasourceID="ObjectDataSourceQ2"
                                            DataTextField="CHOICE_TEXT"  width="100%"
                                            DataValueField="STD_QUESTION_CHOICE_ID" 
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIndex="27">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2"
                                            ControlToValidate="RadioButtonListQ2"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 2 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIndex="28">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="PFA34" />
                                    </td>
                                </tr>
                    <tr id="TrQ3">
                        <td class="questionBackgroundColor"> 
          
                                        <asp:Label ID="Q3Label" AssociatedControlID="RadioButtonListQ3" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIndex="29">
                                        </asp:Label>
                                      
                                    </td>
                                    
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID="RadioButtonListQ3" runat="server" RepeatDirection="Horizontal"
                                            DatasourceID="ObjectDataSourceQ3"
                                            DataTextField="CHOICE_TEXT"  width="100%"
                                            DataValueField="STD_QUESTION_CHOICE_ID" 
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIndex="30">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3"
                                            ControlToValidate="RadioButtonListQ3"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 3 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" SkinID="DataLabel"  TabIndex="31">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="PFA36" />
                                    </td>
                                </tr>
                    <tr id="TrQ4">
                        <td class="questionBackgroundColor">
  
                                        <asp:Label ID="Q4Label" AssociatedControlID="RadioButtonListQ4" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIndex="32">
                                        </asp:Label>              
                                    </td>
                                   
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID="RadioButtonListQ4" runat="server" RepeatDirection="Horizontal"
                                            DatasourceID="ObjectDataSourceQ4"
                                            DataTextField="CHOICE_TEXT"  width="100%"
                                            DataValueField="STD_QUESTION_CHOICE_ID" 
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIndex="33">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4"
                                            ControlToValidate="RadioButtonListQ4"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 4 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" SkinID="DataLabel"  TabIndex="34">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="PFB13" />
                        </td>
                    </tr>
                    <tr id="TrQ5">
                        <td class="questionBackgroundColor">
  
                                        <asp:Label ID="Q5Label" AssociatedControlID="RadioButtonListQ5" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIndex="35">
                                        </asp:Label>
                                       
                                    </td>
                                  
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID="RadioButtonListQ5" runat="server" RepeatDirection="Horizontal"
                                            DatasourceID="ObjectDataSourceQ5"
                                            DataTextField="CHOICE_TEXT"  width="100%"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()" 
                                         SkinID="DataLabel" TabIndex="36">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5"
                                            ControlToValidate="RadioButtonListQ5"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 5 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIndex="37">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="PFB28r1" />
                        </td>
                    </tr>
                    <tr id="TrQ6">
                        <td class="questionBackgroundColor">
                                        <asp:Label ID="Q6Label" AssociatedControlID="RadioButtonListQ6" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIndex="38">
                                        </asp:Label>
                                       
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID="RadioButtonListQ6" runat="server" RepeatDirection="Horizontal"
                                            DatasourceID="ObjectDataSourceQ6"
                                            DataTextField="CHOICE_TEXT"  width="100%"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()" 
                                         SkinID="DataLabel" TabIndex="39">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6"
                                            ControlToValidate="RadioButtonListQ6"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 6 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIndex="40">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="PFB34" />
              
                        </td>
                    </tr>
                      <tr id="TrQ7">
                        <td class="questionBackgroundColor">
                
                                        <asp:Label ID="Q7Label" AssociatedControlID="RadioButtonListQ7" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIndex="41">
                                        </asp:Label>
                                       
                                    </td>
                                    
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID="RadioButtonListQ7" runat="server" RepeatDirection="Horizontal"
                                            DatasourceID="ObjectDataSourceQ7"
                                            DataTextField="CHOICE_TEXT"  width="100%"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()" 
                                         SkinID="DataLabel" TabIndex="42">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7"
                                            ControlToValidate="RadioButtonListQ7"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 7 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIndex="43">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="PFM16" />
                  
                        </td>
                    </tr>
                 </table>
            </asp:Panel>
    <br />
    <asp:Panel ID="PanelScore" Width="100%" runat="server">
        <table cellpadding = "5" cellspacing = "5">
            <tr>
                <td>
                    <asp:Label ID="RawScoreLabel" AssociatedControlID="LabelRawScore" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIndex="44">
                    Raw Score: 
                    </asp:Label>
                </td>
                 <td>
                    <asp:Label ID="LabelRawScore" runat="server" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIndex="45">
                    </asp:Label>
                     <asp:HiddenField ID="hiddenRawScore" runat="server" Value="0"  />
                    
                </td>
                <td width="50%"></td>
                <td>
                &nbsp;
                </td>
                 <td>
                  &nbsp;
                </td>
           </tr>
        </table>
    </asp:Panel>
        <asp:HiddenField ID="ParentNoteID" runat="server" Visible="false" Value="New"  />
    
    <br />
    &nbsp;&nbsp;          
                <asp:Button ID = "btnSaveSurveyDraft" runat = "server"                    
                    UseSubmitBehavior = "false" 
                    Text = "Save Draft" 
                    Width = "130px" 
                    OnClick = "btnSaveSurveyDraft_Click" 
                    ValidationGroup = "OnSaveDraft"
                 SkinID="DataLabel" TabIndex="46" /> 
                       
                <asp:Button ID = "btnSubmitSurvey" runat =  "server"                     
                    UseSubmitBehavior = "false" 
                    Text = "Save and Prepare Note" 
                    Width = "180px" 
                    OnClick = "btnSubmit_Click" 
                    ValidationGroup = "OnSave" 
                 SkinID="DataLabel" TabIndex="47" />
                
                <asp:Button ID = "btnCancelSurvey" runat = "server" 
                     SkinID="DataLabel" TabIndex="48" 
                    UseSubmitBehavior = "false" 
                    Text = "Cancel" 
                    Width = "130px" 
                    OnClick = "btnCancel_Click" 
                />
                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />

                <br />
                <br />     
                <asp:Label ID="LabelSaveInstructions" runat="server" SkinID="DataLabel" TabIndex="49">
                        If you are unable to finish at this time, or if you just want to save while entering, click Save Draft.<br /><br />

                        If you are finished with entry, and ready to save and format the note (you will get another chance to review prior to submit),<br /> 
                        click Save and Prepare Note.<br /><br />     
                          
                        If you want to return to CPRS press the Cancel Button. Do not use Internet browser back arrow.               
                </asp:Label>
                <br />
            
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>

